//=============================================================================
// AmmoRocket.
//=============================================================================
class AmmoFireworks extends DeusExAmmo;

var int gradualHurtSteps;			// how many separate explosions for the staggered HurtRadius
var int gradualHurtCounter;			// which one are we currently doing

var int CurDamage;

var ParticleGenerator smokeGen;

simulated function SpawnSmokeEffects()
{
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
      smokeGen.RemoteRole = ROLE_None;
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.3;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();

	Super.Destroyed();
}

function TakeDamage(int Damage, Pawn EventInstigator, Vector HitLocation, Vector Momentum, name DamageType)
{
 CurDamage += Damage;
 
 ScaleGlow = Default.ScaleGlow - (0.01 * (CurDamage * 4));
 
 if (CurDamage > 0 && smokeGen == None)
 {
  SpawnSmokeEffects();
 }
 
 if ((CurDamage >= 25))
  Explode(Location);
}

//Copied from DeusExDecoration.uc
function Explode(vector HitLocation)
{
	local ShockRing ring;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local MSCClusterPopit CP;

	// make sure we wake up when taking damage
	bStasis = False;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , 128 * 16);

	PlaySound(Sound'LargeExplosion1', SLOT_None,,, 128*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);

	Spawn(class'ExplosionMedium',,, HitLocation);
	light.size = 4;

	CP = Spawn(class'MSCClusterPopit',,, Location);
	CP.DrawScale = 0;
	CP.Speed = 0;
	CP.Velocity = vect(0,0,0);
	CP.Acceleration = vect(0,0,0);

	// draw a pretty shock ring
	ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
	if (ring != None)
		ring.size = 128 / 32.0;
	ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
	if (ring != None)
		ring.size = 128 / 32.0;
	ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
	if (ring != None)
		ring.size = 128 / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(96/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks
	for (i=0; i<128/30+1; i++)
		if (FRand() < 0.8)
			spawn(class'Rockchip',,,HitLocation);

	GotoState('Exploding');
}

state Exploding
{
	ignores Explode;

	function Timer()
	{
		local Pawn apawn;
		local float damageRadius;
		local Vector dist;

		if ( Level.NetMode != NM_Standalone )
		{
			damageRadius = (128 / gradualHurtSteps) * gradualHurtCounter;

			for ( apawn = Level.PawnList; apawn != None; apawn = apawn.nextPawn )
			{
				if ( apawn.IsA('DeusExPlayer') )
				{
					dist = apawn.Location - Location;
					if ( VSize(dist) < damageRadius )
						DeusExPlayer(apawn).myProjKiller = Self;
				}
			}
		}
		HurtRadius
		(
			(2 * 96) / gradualHurtSteps,
			(128 / gradualHurtSteps) * gradualHurtCounter,
			'Exploded',
			(96 / gradualHurtSteps) * 100,
			Location
		);
		if (++gradualHurtCounter >= gradualHurtSteps)
			Destroy();
	}

Begin:
	// stagger the HurtRadius outward using Timer()
	// do five separate blast rings increasing in size
	gradualHurtCounter = 1;
	gradualHurtSteps = 5;
	bHidden = True;
	SetCollision(False, False, False);
	SetTimer(0.5/float(gradualHurtSteps), True);
}

simulated function PostBeginPlay()
{
   Super.PostBeginPlay();

	Multiskins[0] = RandFireworkColor(); 
}

function Texture RandFireworkColor()
{
 local int R;
 
 R = Rand(4);
 
 if (R == 0) return Texture'RawRed';
 if (R == 1) return Texture'RawPurple';
 if (R == 2) return Texture'RawBlue';
 if (R == 3) return Texture'RawGreen';
}

defaultproperties
{
     RespawnTime=0.000000
     bShowInfo=True
     AmmoAmount=1
     MaxAmmo=3
     ItemName="Tylerstanian Firework Rocket"
     ItemArticle="a"
     PickupViewMesh=LodMesh'FireworkRocketP'
     LandSound=Sound'DeusExSounds.Generic.MetalHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconAmmoRockets'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAmmoRockets'
     largeIconWidth=46
     largeIconHeight=36
     Description="A massive payload rocket developed by Tylerstan industries. To not much surprise the country is notorious for constant technological advances in explosives of all sorts."
     beltDescription=""
     Mesh=LodMesh'FireworkRocketP'
     CollisionRadius=6.000000
     CollisionHeight=12.800000
     bCollideActors=True
     bBlockPlayers=True
     bBlockActors=True
     bCollideActors=True
     bProjTarget=True
}
